function updatePriceDisplay(regionId, price, direction, color) {
    let arrow = "";
    let arrowColor = "";

    // Determine the arrow image based on the direction
    if (direction === "up") {
        arrow = "swagimgs/top.svg";
        arrowColor = "green";
    } else if (direction === "down") {
        arrow = "swagimgs/down.svg";
        arrowColor = "red";
    } else {
        arrow = "swagimgs/top.svg";  // No-change
        arrowColor = "green";
    }

    // Handle different regions
    if (regionId === 'gold-price-region24' || regionId === 'gold-price-region21' || regionId === 'gold-price-region18') {
        document.getElementById(regionId).innerHTML = 
            `<h2 style="color: #bea03c; margin: 5px;">Gold ${regionId.includes('24') ? '24K' : regionId.includes('21') ? '21K' : regionId.includes('18') ? '18K':''}</h2>
            <div class="price-up" style="display: flex; align-items: center; justify-content: center;">
                <p class="price" style="color: ${color}; font-size: 20px; font-weight: 800; padding-right: 5px;">${price.toFixed(2)}</p>
                <img src="${arrow}" width="15" height="20">
            </div>
            <img src="swagimgs/sar.svg" width="30" height="25">`;
    }

    if (regionId === 'goldsounces') {
        document.getElementById(regionId).innerHTML = 
            `<img src="swagimgs/golds.png" alt="Gold Coin" class="gold-coin">
            <h2 style="color: #bea03c; margin: 5px; text-align: -webkit-left;">&nbsp; Gold </h2>
            <div class="price-up" style="display: flex; align-items: center; justify-content: left;">
                <p class="price" style="font-size: 20px; font-weight: 900; padding-right: 10px; color:${color};">&nbsp;&nbsp; ${price.toFixed(2)}</p>
                <img src="${arrow}" width="15" height="20">
            </div>`;
    }

    if (regionId === 'silversounces') {
        document.getElementById(regionId).innerHTML = 
            `<img src="swagimgs/silver.png" alt="Silver Coin" class="gold-coin">
            <h2 style="color: #7f807e; margin: 5px; text-align: -webkit-left;">&nbsp; Silver </h2>
            <div class="price-up" style="display: flex; align-items: center; justify-content: left;">
                <p class="price" style="font-size: 20px; font-weight: 900; padding-right: 10px; color:${color};">&nbsp;&nbsp; ${price.toFixed(2)} $</p>
                <img src="${arrow}" width="15" height="20">
            </div>`;
    }

    if (regionId === 'prevclose') {
        document.getElementById(regionId).innerHTML = 
            `<div class="price-up" style="display: flex; align-items: center; justify-content: space-between; width: 100%;">
                <h4 style="color: #be0707; margin: 5px;">&nbsp; low price</h4>
                <p class="price" style="font-size: 18px; font-weight: 900; padding-right: 10px;">${price.toFixed(2)} $</p>
            </div>`;
    }

    if (regionId === 'opening') {
        document.getElementById(regionId).innerHTML = 
            `<div class="price-up" style="display: flex; align-items: center; justify-content: space-between; width: 100%;">
                <h4 style="color: #298b02; margin: 5px;">&nbsp; high price</h4>
                <p class="price" style="font-size: 18px; font-weight: 900; padding-right: 10px;">${price.toFixed(2)} $</p>
            </div>`;
    }
}

// Connect to the Socket.IO server
// const socket = io("https://concat-erp.com:3004");  // Replace with your server URL
// socket.on("connect", () => {
//     console.log("✅ Socket.IO connected successfully");
// });

// socket.on("disconnect", () => {
//     console.log("❌ Socket.IO disconnected");
// });

  const socket = io("https://concat-erp.com:3004");

  socket.on("connect", () => {
    console.log("✅ Connected");
  });

  socket.on("connect_error", (err) => {
    console.error("❌ Connect Error:", err.message);
  });

  socket.on("disconnect", () => {
    console.warn("⚠️ Disconnected");
  });
  socket.on('broadcast prices', (data) => {
//   console.log("Prices received:", data);
  // قم بتحديث واجهة المستخدم هنا بناءً على البيانات
});




socket.on("price_update", (data) => {
    // console.log("🚀 Data received from server:", data);

    const priceChanges = data.priceChanges;
    // console.log("srv priceChanges:", priceChanges);

    // جرب تتأكد من نوعه
    // console.log("Type of priceChanges:", Array.isArray(priceChanges)); // لازم تكون true

    // اجتياز جميع الـ priceChanges وتحديث العناصر المحددة
    priceChanges.forEach((change) => {
        const { priceName, newPrice, direction, color } = change;

        // لو الـ priceName يتطابق مع أي من الـ regionId
        if (['gold-price-region24', 'gold-price-region21', 'gold-price-region18', 'goldsounces', 'silversounces', 'prevclose', 'opening'].includes(priceName)) {
            // console.log("🔄 Updating:", priceName, newPrice);
            updatePriceDisplay(priceName, newPrice, direction, color);
        }
    });
});



// Listen for the 'price_update' event
// socket.on("price_update", (priceChanges) => {
//     console.log("🚀 Data received from server:", priceChanges);
//     // تأكد إن البيانات Array أو حولها لـ Array
//     const updates = Array.isArray(priceChanges) ? priceChanges : [priceChanges];
//     console.log("Received priceChanges:", priceChanges);
//     updates.forEach(change => {
//         updatePriceDisplay(change.priceName, change.newPrice, change.direction, change.color);
//     });
// });